<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN020020 - Find Act Reference Registry Entries Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="VWI/MFMT_MT002001.sch"/>
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN020020-wrapper">
        <param name="element" value="hl7:QUMT_IN020020"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN020020-controlAct">
        <param name="element" value="hl7:QUMT_IN020020/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN020020/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN020020/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN020020/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN020020/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN020020/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:subject/hl7:registrationProcess">
            <assert role="error" test="@moodCode='EVN'"
                >@moodCode moet 'EVN' zijn</assert>
            <assert role="warning" test="hl7:id"
                >registrationProcess/id is verplicht</assert>
            <assert role="error" test="count(hl7:subject2)=1"
                >registrationProcess/subject2 moet exact één maal voorkomen. Registraties van meer dan één Act zijn niet toegestaan</assert>
            <assert role="error" test="not(hl7:subject1)"
                >registrationProcess/subject1 is niet toegestaan in de Verwijsindex</assert>
        </rule>
        <title>registrationProcess/statusCode</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active'"
                >statusCode/@code moet 'active' zijn.</assert>
        </rule>
        <title>registrationProcess/effectiveTime</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="@nullFlavor='UNK' or hl7:low"
                >effectiveTime/@nullFlavor moet 'UNK' zijn, of effectiveTime/low/@value moet de eerste aanmelddatum bevatten</assert>
        </rule>
    </pattern>
    
    <pattern is-a="MFMT_MT002001" id="QUMT_IN020020-MFMT_MT002001">
        <param name="element" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:ActReference"/>
    </pattern>
</schema>
